<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightPadAircraftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flight_pad_aircrafts', function (Blueprint $table) {
            $table->increments('id');
            $table->string('image_name')->nullable();
            $table->integer('category')->nullable();
            $table->integer('id_backend')->nullable();
            $table->string('type')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('model')->nullable();
            $table->string('display_manufacturer')->nullable();
            $table->string('display_name')->nullable();
            $table->string('variant')->nullable();
            $table->string('callsign')->nullable();
            $table->string('unit')->nullable();
            $table->integer('BEW')->nullable();
            $table->string('moment_long')->nullable();
            $table->string('moment_lat')->nullable();
            $table->integer('MTOW')->nullable();
            $table->integer('max_fuel')->nullable();
            $table->text('description_line1')->nullable();
            $table->text('description_line2')->nullable();
            $table->string('version')->nullable();
            $table->string('internal_remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flight_pad_aircrafts');
    }
}
